﻿using System;
using System.Linq;
using System.Net;
using System.Text;
using System.Xml.Linq;
using Microsoft.VisualBasic;

namespace Azyobuzi.りすにんぐついったー
{
    //http://twitter.com/pixy_tom/status/27318124014
    public class NpmHashtagCreater
    {
        public string YahooAppId { set; get; }
        public string BitlyUserName { set; get; }
        public string BitlyApiKey { set; get; }

        public string CreateHashtag(string artist, string album)
        {
            try
            {
                if (string.IsNullOrWhiteSpace(artist) || string.IsNullOrWhiteSpace(album)) return null;
                using (WebClient wc = new WebClient())
                {
                    wc.Encoding = Encoding.UTF8;

                    string tagString = artist + album;
                    string temp = System.Text.RegularExpressions.Regex.Replace(
                        Strings.StrConv(tagString, VbStrConv.Lowercase | VbStrConv.Narrow),
                        @"[,\.\/\\;:\]\[@`\{\}\*\+_\?><!""#\$%&'\(\)\-=\^~\|．。、「」\s]", "");

                    XElement xml;
                    string uri = string.Format("http://jlp.yahooapis.jp/FuriganaService/V1/furigana?appid={0}&sentence={1}",
                        YahooAppId, Uri.EscapeDataString(temp));
                    xml = XElement.Parse(wc.DownloadString(uri));
                    var ns = xml.Name.Namespace;
                    xml.Descendants(ns + "Word").Where(o => o.Element(ns + "Furigana") != null).ToList()
                        .ForEach(xe => temp = temp.Replace(xe.Element(ns + "Surface").Value, xe.Element(ns + "Furigana").Value));

                    temp = temp.Replace('が', 'か').Replace('ぎ', 'き').Replace('ぐ', 'く').Replace('げ', 'け').Replace('ご', 'こ')
                        .Replace('ざ', 'さ').Replace('じ', 'し').Replace('ず', 'す').Replace('ぜ', 'せ').Replace('ぞ', 'そ')
                        .Replace('だ', 'た').Replace('ぢ', 'ち').Replace('づ', 'つ').Replace('で', 'て').Replace('ど', 'と')
                        .Replace('ば', 'は').Replace('び', 'ひ').Replace('ぶ', 'ふ').Replace('べ', 'へ').Replace('ぼ', 'ほ')
                        .Replace('ぱ', 'は').Replace('ぴ', 'ひ').Replace('ぷ', 'ふ').Replace('ぺ', 'へ').Replace('ぽ', 'ほ')
                        .Replace('ぁ', 'あ').Replace('ぃ', 'い').Replace('ぅ', 'う').Replace('ぇ', 'え').Replace('ぉ', 'お')
                        .Replace('ゃ', 'や').Replace('ゅ', 'ゆ').Replace('ょ', 'よ').Replace("ヴ", "ふ");

                    uri = string.Format("http://jlp.yahooapis.jp/FuriganaService/V1/furigana?appid={0}&sentence={1}",
                            YahooAppId, Uri.EscapeDataString(temp));
                    xml = XElement.Parse(wc.DownloadString(uri));
                    ns = xml.Name.Namespace;
                    xml.Descendants(ns + "Word").Where(o => o.Element(ns + "Roman") != null).ToList()
                        .ForEach(xe => temp = temp.Replace(xe.Element(ns + "Surface").Value, xe.Element(ns + "Roman").Value));

                    string tempUri = "http://www.amazon.com/" + Uri.EscapeDataString(temp);
                    uri = string.Format("http://api.bit.ly/v3/shorten?login={0}&apikey={1}&longUrl={2}&format=xml", BitlyUserName, BitlyApiKey, tempUri);
                    xml = XElement.Parse(wc.DownloadString(uri));

                    return "#NPM" + xml.Descendants("url").First().Value.Substring("http://amzn.to/".Length);
                }
            }
            catch
            {
                return null;
            }
        }
    }
}
